/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals;

import com.almostreliable.summoningrituals.Setup;
import com.almostreliable.summoningrituals.altar.AltarBlock;
import com.almostreliable.summoningrituals.altar.AltarRenderer;
import com.almostreliable.summoningrituals.network.PacketHandler;
import com.almostreliable.summoningrituals.util.TextUtils;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="summoningrituals")
public class SummoningRituals {
    public SummoningRituals() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(SummoningRituals::onCommonSetup);
        modEventBus.addListener(SummoningRituals::onClientSetup);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(EventPriority.LOWEST, SummoningRituals::onRightClick);
        forgeEventBus.addListener(SummoningRituals::onLivingDrops);
        Setup.init(modEventBus);
    }

    private static void onCommonSetup(FMLCommonSetupEvent event) {
        PacketHandler.init();
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Setup.ALTAR_BLOCK.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Setup.INDESTRUCTIBLE_ALTAR_BLOCK.get()), (RenderType)RenderType.m_110463_());
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Setup.ALTAR_ENTITY.get()), AltarRenderer::new);
        });
    }

    private static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.m_21120_(InteractionHand.MAIN_HAND);
        Block block = event.getWorld().m_8055_(event.getPos()).m_60734_();
        if (player.m_6144_() == item.m_41619_() && block instanceof AltarBlock) {
            event.setUseBlock(Event.Result.ALLOW);
            event.setUseItem(Event.Result.DENY);
            event.setCanceled(false);
        }
    }

    private static void onLivingDrops(LivingDropsEvent event) {
        if (event.getEntity().m_19880_().contains(TextUtils.f("{}_sacrificed", "summoningrituals"))) {
            event.setCanceled(true);
        }
    }
}

